<?php

// Create a option page for settings
add_action('admin_menu', 'add_webchat_option_page');

// Add top-level admin bar link
add_action('admin_bar_menu', 'add_webchat_link_to_admin_bar', 999);

// Adds webchat link to top-level admin bar
function add_webchat_link_to_admin_bar()
{
  global $wp_version;
  global $wp_admin_bar;

  $webchat_icon = '<img src="' .chatembed_PATH . './assets/webchat.png' . '">';

  $args = array(
    'id' => 'webchat-admin-menu',
    'title' => '<span class="ab-icon" ' . ($wp_version < 3.8 && !is_plugin_active('mp6/mp6.php') ? ' style="margin-top: 3px;"' : '') . '>'. '</span><span class="ab-label">Chat Embed</span>', // alter the title of existing node
    'parent' => FALSE,   // set parent to false to make it a top level (parent) node
    'href' => get_bloginfo('wpurl') . '/wp-admin/admin.php?page=menus.php',
    'meta' => array('title' => 'Chat Embed Settings')
  );

  $wp_admin_bar->add_node($args);
}

// Hook in the options page functionå
function add_webchat_option_page()
{
  add_options_page('webchat Options', 'Chat Embed', 'activate_plugins', basename(__FILE__), 'webchat_options_page');
}

?>
