<?php

// Add the webchat Javascript
add_action('wp_footer', 'add_webchat');


// The guts of the webchat script
function add_webchat()
{
  // Ignore admin, feed, robots or trackbacks
  if ( is_feed() || is_robots() || is_trackback() )
  {
    return;
  }

  $options = get_option('webchat_settings');

  // If options is empty then exit
  if( empty( $options ) )
  {
    return;
  }

  // Check to see if webchat is enabled
  if ( esc_attr( $options['webchat_enabled'] ) == "on" )
  {
    $webchat_tag = $options['webchat_widget_code'];

    // Insert tracker code
    if ( '' != $webchat_tag )
    {
      echo "<!-- Start webchat Webchat Code -->\n";
      echo $webchat_tag;
      echo"<!-- end: webchat Webchat Code. -->\n";


    }
  }
}
?>
