<?php

// Output the options page
function webchat_options_page()
{
  // Get options
  $options = get_option('webchat_settings');

  // Check to see if webchat is enabled
  $webchat_activated = false;
  if ( esc_attr( $options['webchat_enabled'] ) == "on" ) {
    $webchat_activated = true;
    wp_cache_flush();
  }


?>
        <div class="wrap">
        <form name="webchat-form" action="options.php" method="post" enctype="multipart/form-data">
          <?php settings_fields( 'webchat_settings_group' ); ?>

            <h1>Chat Embed Webchat</h1>
            <h3>Basic Options</h3>
            <?php if ( ! $webchat_activated ) { ?>
                <div style="margin:10px auto; border:3px #f00 solid; background-color:#fdd; color:#000; padding:10px; text-align:center;">
                Web Chat is currently <strong>DISABLED</strong>.
                </div>
            <?php } ?>
            <?php do_settings_sections( 'webchat_settings_group' ); ?>

            <table class="form-table" cellspacing="2" cellpadding="5" width="100%">
                <tr>
                    <th width="30%" valign="top" style="padding-top: 10px;">
                        <label for="webchat_enabled">Webchat is:</label>
                    </th>
                    <td>
                      <?php
                          echo "<select name=\"webchat_settings[webchat_enabled]\"  id=\"webchat_enabled\">\n";

                          echo "<option value=\"on\"";
                          if ( $webchat_activated ) { echo " selected='selected'"; }
                          echo ">Enabled</option>\n";

                          echo "<option value=\"off\"";
                          if ( ! $webchat_activated ) { echo" selected='selected'"; }
                          echo ">Disabled</option>\n";
                          echo "</select>\n";
                        ?>
                    </td>
                </tr>
            </table>
                <table class="form-table" cellspacing="2" cellpadding="5" width="100%">
                <tr>
                    <th valign="top" style="padding-top: 10px;">
                        <label for="webchat_widget_code">webchat Script:</label>
                    </th>
                    <td>
                      <textarea rows="5" cols="120" placeholder="<!-- Insert the webchat script here -->" name="webchat_settings[webchat_widget_code]"><?php echo esc_attr( $options['webchat_widget_code'] ); ?></textarea>
                        <p style="margin: 5px 10px;">Please Enter Your Chat Embed Script Above </p>
                    </td>
                </tr>
                </table>
            <p class="submit">
                <?php echo submit_button('Save Changes'); ?>
            </p>
        </div>
        </form>

<?php
}
?>
